<?php

namespace App\Http\Controllers\API\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\UsersResource;
use App\Models\User;
use App\Http\Requests\API\Account\UpdateCustomerGeneralInfoRequest;
use App\Http\Requests\API\Account\UpdateTherapistGeneralInfoRequest;
use App\Http\Requests\API\Account\UpdateTherapistCommunityGeneralInfoRequest;
use App\Models\Role;

class APIAccountController extends Controller
{
    public function __construct()
    {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware(['customer.api'])->only(['updateCustomerGeneralInformation']);
        $this->middleware(['therapist.api'])->only(['updateTherapistGeneralInformation' , 'updateTherapistSettings']);
        $this->middleware(['therapistcommunity.api'])->only(['updateTherapistCommunityGeneralInformation' , 'updateTherapistCommunitySettings']);
    }

    public function updateCustomerGeneralInformation(UpdateCustomerGeneralInfoRequest $request)
    {
        $user = auth()->user();
        $customer = $user->customer;
        if($customer){
            $customer->update($request->only(['first_name','last_name','user_name','description','country_id','state_id','city_id','address_line_1','address_line_2','zip_code']));
            if(!empty($request->image) && !is_null($request->image)){
                $image = uploadFile($request,'image','profile_images');
                $customer->update(['image' => $image]);
            }

            $user = User::withAll()->where('email', $user->email)->first();
            $user = new UsersResource($user);
            $response = generateResponse($user,true,"Profile Updated Successfully",null,'collection');
        }else{
            $response = generateResponse(null,true,"User Not Found",null,'collection');
        }
        return response()->json($response);
    }

    public function updateTherapistGeneralInformation(UpdateTherapistGeneralInfoRequest $request)
    {
        $user = auth()->user();
        $therapist = $user->therapist;
        if($therapist){
            $therapist->update($request->only(
                ['first_name',
                'last_name',
                'description',
                'country_id',
                'state_id',
                'city_id',
                'address_line_1',
                'address_line_2',
                'zip_code',
                'user_name',
                'speciality',
                'home_phone',
                'cell_phone',
                'job_title',
                'website',
                'company',
                'email',
                'work_country_id',
                'work_state_id',
                'work_city_id',
                'work_address_line_1',
                'work_address_line_2',
                'work_zip_code',
                'shipping_country_id',
                'shipping_state_id',
                'shipping_city_id',
                'shipping_address_line_1',
                'shipping_address_line_2',
                'shipping_zip_code',
                'billing_country_id',
                'billing_state_id',
                'billing_city_id',
                'billing_address_line_1',
                'billing_address_line_2',
                'billing_zip_code'
                ]));

                if(!empty($request->image) && !is_null($request->image)){
                    $image = uploadFile($request,'image','profile_images');
                    $therapist->update(['image' => $image]);
                }
                if(!empty($request->cover_image) && !is_null($request->cover_image)){
                    $cover_image = uploadFile($request,'cover_image','profile_images');
                    $therapist->update(['cover_image' => $cover_image]);
                }
            $therapist->therapist_categories()->sync($request->therapist_categories);
            $therapist->languages()->sync($request->languages);
            $therapist->tags()->sync($request->tags);
            $user = User::withAll()->where('email', $user->email)->first();
            $user = new UsersResource($user);
            $response = generateResponse($user,true,"Profile Updated Successfully",null,'collection');
        }else{
            $response = generateResponse(null,true,"User Not Found",null,'collection');
        }
        return response()->json($response);
    }

    public function updateTherapistSettings(Request $request){
        $user = Auth::user();
        $therapist = $user->therapist;
        foreach($request->settings as $setting){
            $therapist->therapist_settings()->updateOrCreate(['name' => $setting['name']],$setting);
        }
        $response = generateResponse(null,true,"Settings Updated Successfully",null,'collection');
        return response()->json($response);
    }

    public function updateTherapistCommunityGeneralInformation(UpdateTherapistCommunityGeneralInfoRequest $request)
    {
        $user = auth()->user();
        $therapist_community = $user->therapist_community;
        if($therapist_community){
            $therapist_community->update($request->only(['therapist_community_name','therapist_community_website','first_name','last_name','description','country_id','state_id','city_id','address_line_1','address_line_2','zip_code','user_name']));
            $image = uploadCroppedFile($request,'image','profile_images');
            $therapist_community->update(['image' => $image]);
            $therapist_community->therapist_community_categories()->sync($request->therapist_community_categories);
            $response = generateResponse($therapist_community,true,"Profile Updated Successfully",null,'collection');
        }else{
            $response = generateResponse(null,true,"User Not Found",null,'collection');
        }
        return response()->json($response);
    }

    public function updateTherapistCommunitySettings(Request $request){
        $user = Auth::user();
        $therapist_community = $user->therapist_community;
        foreach($request->settings as $setting){
            $therapist_community->therapist_community_settings()->updateOrCreate(['name' => $setting['name']],$setting);
        }
        $response = generateResponse(null,true,"Settings Updated Successfully",null,'collection');
        return response()->json($response);
    }

    public function becomeTherapist(Request $request){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        $pricing_plan = getTherapistDefaultPricingPlan();

        if(!$user->hasRole(Role::$Therapist)){
            $user->roles()->attach([Role::$Therapist]);
            $user->therapist()->create([
                'first_name' => $data->first_name,
                'last_name' => $data->last_name,
                'description' => $data->description,
                'country_id' => $data->country_id,
                'state_id' => $data->state_id,
                'city_id' => $data->city_id,
                'address_line_1' => $data->address_line_1,
                'address_line_2' => $data->address_line_2,
                'zip_code' => $data->zip_code,
                'pricing_plan_id' => $pricing_plan->id ?? null
            ]);
        }
        $response = generateResponse(null,true,"You are Now A Therapist",null,'collection');
        return response()->json($response);
    }
    public function becomeUser(Request $request){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        if(!$user->hasRole(Role::$Customer)){
            $user->roles()->attach([Role::$Customer]);
            $user->customer()->create([
                'first_name' => $data->first_name,
                'last_name' => $data->last_name,
                'description' => $data->description,
                'country_id' => $data->country_id,
                'state_id' => $data->state_id,
                'city_id' => $data->city_id,
                'address_line_1' => $data->address_line_1,
                'address_line_2' => $data->address_line_2,
                'zip_code' => $data->zip_code,

            ]);
        }
        $response = generateResponse(null,true,"You are Now A Cusomer",null,'collection');
        return response()->json($response);
    }
    public function becomeTherapistCommunity(Request $request){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        $pricing_plan = getTherapistCommunityDefaultPricingPlan();
        if(!$user->hasRole(Role::$TherapistCommunity)){
            $user->roles()->attach([Role::$TherapistCommunity]);
            $user->therapist_community()->create([
                'first_name' => $data->first_name,
                'last_name' => $data->last_name,
                'description' => $data->description,
                'country_id' => $data->country_id,
                'state_id' => $data->state_id,
                'city_id' => $data->city_id,
                'address_line_1' => $data->address_line_1,
                'address_line_2' => $data->address_line_2,
                'zip_code' => $data->zip_code,
                'pricing_plan_id' => $pricing_plan->id ?? null
            ]);
        }
        $response = generateResponse(null,true,"You are Now A Therapist Community User Also",null,'collection');
        return response()->json($response);
    }
}
